/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.datagen;

import com.google.common.base.Preconditions;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "numismaticoverhaul", existingFileHelper);
    }

    protected void registerModels() {
    }

    protected ItemModelBuilder simpleBlockItemModel(Block block) {
        String name = this.getName(block);
        return (ItemModelBuilder)this.withExistingParent(name, this.modLoc("block/" + name));
    }

    protected ItemModelBuilder simpleGeneratedModel(Item item) {
        return this.simpleModel(item, this.mcLoc("item/generated"));
    }

    protected ItemModelBuilder simpleHandHeldModel(Item item) {
        return this.simpleModel(item, this.mcLoc("item/handheld"));
    }

    protected ItemModelBuilder simpleModel(Item item, ResourceLocation parent) {
        String name = this.getName(item);
        return (ItemModelBuilder)this.singleTexture(name, parent, "layer0", this.modLoc("item/" + name));
    }

    protected String getName(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
    }

    protected String getName(Block item) {
        return ForgeRegistries.BLOCKS.getKey((Object)item).m_135815_();
    }

    public ItemModelBuilder getBuilder(String path) {
        Preconditions.checkNotNull((Object)path, (Object)"Path must not be null");
        ResourceLocation outputLoc = this.extendWithFolder(path.contains(":") ? new ResourceLocation(path) : new ResourceLocation(this.modid, path));
        this.existingFileHelper.trackGenerated(outputLoc, (ExistingFileHelper.IResourceType)MODEL);
        return this.generatedModels.computeIfAbsent(outputLoc, loc -> new ItemModelBuilder(loc, this.existingFileHelper));
    }

    private ResourceLocation extendWithFolder(ResourceLocation rl) {
        if (rl.m_135815_().contains("/")) {
            return rl;
        }
        return new ResourceLocation(rl.m_135827_(), this.folder + "/" + rl.m_135815_());
    }
}

